
#include <stdint.h>

typedef enum {
  eAlarm,
  eOff,
  eTick,
} Event;

extern Event evt();

typedef enum {
  sOff,
  sBeep,
  sPause
} Status;
static Status  status = sOff;
static uint8_t timer;

extern void bell(bool on);

void beep(){
  while( true ){
    switch( evt() ){
      case eAlarm:
        if(status == sOff){
          status = sBeep;
          bell(true);
          timer = 20;
        }
        break;
      
      case eOff:
        status = sOff;
        bell(false);
        break;
        
      case eTick:
        if(status != sOff){
          if(timer > 0){
            timer--;
          } else {
            if(status == sBeep){
              status = sPause;
              bell(false);
              timer = 80;
            } else {
              status = sBeep;
              bell(true);
              timer = 20;
            }
          }
        }
        break;
    }
  }
}






